#---------------------------------------------------------------------------------------------------
# This R code generates Fig. 2 of the main text (convolution of full and sparse kernels).
# The code uses function `cumMove' in R package `openCR' version 2.1.0 
# https://CRAN.R-project.org/package=openCR
# That function calls C++ code to speed execution.
#---------------------------------------------------------------------------------------------------
library(openCR)
grid <- make.grid()
sp <- 10
msk <- make.mask(grid, spacing = sp, buffer = 200)
kF <- make.kernel('BVE', 20, spacing = sp, move.a = 20, clip = TRUE, 
    sparse = F)
kS <- make.kernel('BVE', 20, spacing = sp, move.a = 20, clip = TRUE, 
    sparse = T)
par(mfrow = c(2,4), mar = c(0,0,0,0), oma = c(1,3,3,1))
X <- data.frame(x = 50, y = 50)
xy0 <- X
for (step in 1:4) {
    X <- cumMove(X, msk, kF, nstep = 1)
    plot(X, cov = 'pm', dots = FALSE, legend = FALSE, breaks = 
            seq(0,0.006,0.0001))
    contour(
        x = unique(X$x), 
        y = unique(X$y), 
        z = matrix(covariates(X)$pm, nrow = length(unique(X$x))), 
        levels = c(0.0002), 
        drawlabels = FALSE,
        lwd = 0.6,
        add = TRUE)
}
X <- data.frame(x = 50, y = 50)
xy0 <- X
for (step in 1:4) {
    X <- cumMove(X, msk, kS, nstep = 1)
    plot(X, cov = 'pm', dots = FALSE, legend = FALSE, breaks = 
            seq(0,0.006,0.0001))
    contour(
        x = unique(X$x), 
        y = unique(X$y), 
        z = matrix(covariates(X)$pm, nrow = length(unique(X$x))), 
        levels = c(0.0002), 
        drawlabels = FALSE,
        lwd = 0.6,
        add = TRUE)
}
mtext(side=2, line=0.75, at = c(0.25,0.75), c('Sparse','Full'), cex=1, outer = TRUE)
mtext(side=3, line=0.5, at = seq(0.125,0.95,0.25), paste('Step', 1:4), cex=1, outer = TRUE)
#---------------------------------------------------------------------------------------------------

